// evc8840Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "evc8840.h"
#include "evc8840Dlg.h"
#include "evc8840lib.h"
#include "IO_TEST.h"
#include "SYSPARASET.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
int devnum;
/////////////////////////////////////////////////////////////////////////////
// CEvc8840Dlg dialog

CEvc8840Dlg::CEvc8840Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEvc8840Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEvc8840Dlg)
	m_end_placex = 0;
	m_end_placey = 0;
	m_end_placez = 0;
	m_end_placea = 0;
	m_act_placea = 0;
	m_act_placex = 0;
	m_act_placey = 0;
	m_act_placez = 0;
	m_bX = FALSE;
	m_bY = FALSE;
	m_bZ = FALSE;
	m_bA = FALSE;
	m_log_placey = 0;
	m_log_placez = 0;
	m_log_placex = 0;
	m_log_placea = 0;
	m_wspeeda = 2000;
	m_wspeedx = 2000;
	m_wspeedy = 2000;
	m_wspeedz = 2000;
	m_speeda = 0;
	m_speedx = 0;
	m_speedy = 0;
	m_speedz = 0;
	m_adda = 100;
	m_addx = 100;
	m_addy = 100;
	m_addz = 100;
	m_pulsea = 4000;
	m_pulsex = 5000;
	m_pulsey = 6000;
	m_pulsez = 7000;
	m_starta = 500;
	m_startx = 500;
	m_startz = 500;
	m_starty = 500;
	m_buffmode = FALSE;
	m_speedmode = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CEvc8840Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEvc8840Dlg)
	DDX_Text(pDX, IDC_END_PLACEX, m_end_placex);
	DDX_Text(pDX, IDC_END_PLACEY, m_end_placey);
	DDX_Text(pDX, IDC_END_PLACEZ, m_end_placez);
	DDX_Text(pDX, IDC_END_PLACEA, m_end_placea);
	DDX_Text(pDX, IDC_ACT_PLACEA, m_act_placea);
	DDX_Text(pDX, IDC_ACT_PLACEX, m_act_placex);
	DDX_Text(pDX, IDC_ACT_PLACEY, m_act_placey);
	DDX_Text(pDX, IDC_ACT_PLACEZ, m_act_placez);
	DDX_Check(pDX, IDC_CHECK17, m_bX);
	DDX_Check(pDX, IDC_CHECK18, m_bY);
	DDX_Check(pDX, IDC_CHECK19, m_bZ);
	DDX_Check(pDX, IDC_CHECK20, m_bA);
	DDX_Text(pDX, IDC_LOG_PLACEY, m_log_placey);
	DDX_Text(pDX, IDC_LOG_PLACEZ, m_log_placez);
	DDX_Text(pDX, IDC_LOG_PLACEX, m_log_placex);
	DDX_Text(pDX, IDC_LOG_PLACEA, m_log_placea);
	DDX_Text(pDX, IDC_WSPEEDA, m_wspeeda);
	DDX_Text(pDX, IDC_WSPEEDX, m_wspeedx);
	DDX_Text(pDX, IDC_WSPEEDY, m_wspeedy);
	DDX_Text(pDX, IDC_WSPEEDZ, m_wspeedz);
	DDX_Text(pDX, IDC_SPEEDA, m_speeda);
	DDX_Text(pDX, IDC_SPEEDX, m_speedx);
	DDX_Text(pDX, IDC_SPEEDY, m_speedy);
	DDX_Text(pDX, IDC_SPEEDZ, m_speedz);
	DDX_Text(pDX, IDC_ADDSA, m_adda);
	DDX_Text(pDX, IDC_ADDSX, m_addx);
	DDX_Text(pDX, IDC_ADDSY, m_addy);
	DDX_Text(pDX, IDC_ADDSZ, m_addz);
	DDX_Text(pDX, IDC_PULSE_A, m_pulsea);
	DDX_Text(pDX, IDC_PULSE_X, m_pulsex);
	DDX_Text(pDX, IDC_PULSE_Y, m_pulsey);
	DDX_Text(pDX, IDC_PULSE_Z, m_pulsez);
	DDX_Text(pDX, IDC_STARTA, m_starta);
	DDX_Text(pDX, IDC_STARTX, m_startx);
	DDX_Text(pDX, IDC_STARTZ, m_startz);
	DDX_Text(pDX, IDC_STARTY, m_starty);
	DDX_Check(pDX, IDC_BUF_MODE, m_buffmode);
	DDX_Check(pDX, IDC_SPEEDMODE, m_speedmode);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CEvc8840Dlg, CDialog)
	//{{AFX_MSG_MAP(CEvc8840Dlg)
	ON_EN_CHANGE(IDC_IP_CONN, OnChangeIpConn)
	ON_BN_CLICKED(IDC_BUTTON1, OnConn_Cmd)
	ON_BN_CLICKED(IDC_PMOV, OnPmov)
	ON_WM_TIMER()
	ON_EN_CHANGE(IDC_PULSE_X, OnChangePulseX)
	ON_BN_CLICKED(IDC_STOP_ALL, OnStopAll)
	ON_BN_CLICKED(IDC_CLEAR_POS, OnClearPos)
	ON_BN_CLICKED(IDC_INP_MOVE, OnInpMove)
	ON_EN_CHANGE(IDC_STARTX, OnChangeStartx)
	ON_EN_CHANGE(IDC_STARTY, OnChangeStarty)
	ON_EN_CHANGE(IDC_STARTZ, OnChangeStartz)
	ON_EN_CHANGE(IDC_STARTA, OnChangeStarta)
	ON_EN_CHANGE(IDC_WSPEEDX, OnChangespeedx)
	ON_EN_CHANGE(IDC_WSPEEDY, OnChangespeedy)
	ON_EN_CHANGE(IDC_WSPEEDZ, OnChangespeedz)
	ON_EN_CHANGE(IDC_WSPEEDA, OnChangespeeda)
	ON_EN_CHANGE(IDC_ADDSX, OnChangeAddsx)
	ON_EN_CHANGE(IDC_ADDSY, OnChangeAddsy)
	ON_EN_CHANGE(IDC_ADDSZ, OnChangeAddsz)
	ON_EN_CHANGE(IDC_ADDSA, OnChangeAddsa)
	ON_BN_CLICKED(IDC_FIFO, OnFifo)
	ON_BN_CLICKED(IDC_PAUSE, OnPause)
	ON_BN_CLICKED(IDC_CONTINUE, OnContinue)
	ON_BN_CLICKED(IDC_IO_TEST, OnIoTest)
	ON_BN_CLICKED(IDC_Resume, OnResume)
	ON_BN_CLICKED(IDC_BUF_MODE, OnBufMode)
	ON_BN_CLICKED(IDC_SPEEDMODE, OnSpeedmode)
	ON_BN_CLICKED(IDC_BUTTON5, OnSYSSET)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEvc8840Dlg message handlers

BOOL CEvc8840Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	CenterWindow(GetDesktopWindow());	// center to the hpc screen
	DeviceAddr_init();
	SetDlgItemText(IDC_EDIT_INF,_T(""));
	SetDlgItemText(IDC_EDIT_INF,_T("ϵͳʼOK"));
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}



void CEvc8840Dlg::OnChangeIpConn() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	
}

void CEvc8840Dlg::OnConn_Cmd() 
{
	// TODO: Add your control notification handler code here
	CString ID,ip_addr,mac_str;
	int len,mode =0, err=0;
	UINT sock1=0;
	char str[32],ip_in[32]={0},arp_in[32]={0};
//	CButton *btn;

    UpdateData(FALSE);
        //״̬
	GetDlgItemText(IDC_IP_CONN,ip_addr); 
	len=ip_addr.GetLength()+1;
	sprintf(ip_in, "%S ",ip_addr); 

	RETAILMSG(1,(TEXT("ip:%s\n"),ip_in));
	devnum=TCP_Conn(ip_in,arp_in,&err);
	
	if(devnum !=-1 )
	{
		sprintf(str,"%d", devnum);
		ID=str;
		SetDlgItemText(IDC_DEVID,ID);
		SetDlgItemText(IDC_CONN_STATUS,_T("OK"));
		SetDlgItemText(IDC_EDIT_INF,_T("OK"));
		OnSpeedmode();
		SetTimer(MAINTIMER,50,NULL); 

	}
	else
	{
		SetDlgItemText(IDC_DEVID,_T(""));
		SetDlgItemText(IDC_CONN_STATUS,_T("ʧ"));
		switch(err)
		{
		case 0:
			break;
		case 1:
			SetDlgItemText(IDC_EDIT_INF,_T("Ѿ"));
			break;
		case 2:
			SetDlgItemText(IDC_EDIT_INF,_T(""));
			break;
		case 3:
			SetDlgItemText(IDC_EDIT_INF,_T("SOCKETʧ"));
			break;
		default:
			SetDlgItemText(IDC_EDIT_INF,_T("TCPʧ"));	
			break;
		}
	}
}

void CEvc8840Dlg::OnPmov() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
    //***********************//
	if(m_bX && !m_bY && !m_bZ && !m_bA) 
	{
		adt8840a_pmove(devnum,1,m_pulsex);
	}		
	else if(!m_bX && m_bY && !m_bZ && !m_bA)
	{
		adt8840a_pmove(devnum,2,m_pulsey);
	}
	else if(!m_bX && !m_bY && m_bZ && !m_bA)
	{
		adt8840a_pmove(devnum,3,m_pulsez);
	}
	else if(!m_bX && !m_bY && !m_bZ && m_bA)
	{
		adt8840a_pmove(devnum,4,m_pulsea);
	}
    //***********************//
	else if(m_bX && m_bY && !m_bZ && !m_bA)             //XY
	{
		adt8840a_pmove2(devnum,1, 2, m_pulsex, m_pulsey);
	}
	else if(m_bX && !m_bY && m_bZ && !m_bA)             //XZ
	{
		adt8840a_pmove2(devnum,1, 3, m_pulsex, m_pulsez);
	}
	else if(m_bX && !m_bY && !m_bZ && m_bA)             //XA
	{
		adt8840a_pmove2(devnum, 1, 4, m_pulsex, m_pulsea);
	}
	else if(!m_bX && m_bY && m_bZ && !m_bA)            //YZ
	{
		adt8840a_pmove2(devnum, 2, 3, m_pulsey, m_pulsez);
	}
	else if(!m_bX && m_bY && !m_bZ && m_bA)            //YA
	{
		adt8840a_pmove2(devnum, 2, 4, m_pulsey, m_pulsea);
	}
	else if(!m_bX && !m_bY && m_bZ && m_bA)            //ZA
	{
		adt8840a_pmove2(devnum,3, 4, m_pulsez, m_pulsea);
	}
	
    //***************************//
	else if(m_bX && m_bY && m_bZ && !m_bA) //XYZ
	{
		adt8840a_pmove3(devnum,1, 2, 3, m_pulsex, m_pulsey, m_pulsez);
	}
	else if(m_bX && m_bY && !m_bZ && m_bA) //XYA
	{
		adt8840a_pmove3(devnum,1, 2, 4, m_pulsex, m_pulsey, m_pulsea);
	}
	else if(m_bX && !m_bY && m_bZ && m_bA) //XZA岹
	{
		adt8840a_pmove3(devnum,1, 3, 4, m_pulsex, m_pulsez, m_pulsea);
	}
	else if(!m_bX && m_bY && m_bZ && m_bA) //YZA
	{
		adt8840a_pmove3(devnum,1, 3, 4, m_pulsex, m_pulsez, m_pulsea);
	}
	
    //**********************//
	else if(m_bX && m_bY && m_bZ && m_bA)            //XYZW
	{
		adt8840a_pmove4(devnum,m_pulsex, m_pulsey,m_pulsez, m_pulsea);
	}
	else
	{
		MessageBox(_T("ѡ!"));
	}
}



//********************ʵʱȡ״̬*************************//
//     ȡ߼λáʵλáٶȺ״̬          //
//     ȡλstop0                     //
//*********************************************************//


void CEvc8840Dlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	long log[4],act=0,spd=0;
	UpdateData(TRUE);
	switch(nIDEvent) 
	{
		case MAINTIMER :
		{
			adt8840a_all_command_pos(devnum,log);
			m_log_placex=log[0];
			m_log_placey=log[1];
			m_log_placez=log[2];
			m_log_placea=log[3];
			adt8840a_all_actual_pos(devnum,log);
			m_act_placex=log[0];
			m_act_placey=log[1];
			m_act_placez=log[2];
			m_act_placea=log[3];
			adt8840a_all_speed(devnum,log);
			m_speedx=log[0];
			m_speedy=log[1];
			m_speedz=log[2];
			m_speeda=log[3];
			break;
		}
	}

	//RETAILMSG(1,(TEXT("log_:%d\n"),m_log_placex));
	UpdateData(FALSE);
	CDialog::OnTimer(nIDEvent);
}

void CEvc8840Dlg::OnChangePulseX() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
}

void CEvc8840Dlg::OnStopAll() 
{
	// TODO: Add your control notification handler code here
	adt8840a_stop_all(devnum);
}

void CEvc8840Dlg::OnClearPos() 
{
	// TODO: Add your control notification handler code here
	adt8840a_set_command_pos(devnum,1,0);
	adt8840a_set_actual_pos (devnum,1,0);
	adt8840a_set_command_pos(devnum,2,0);
	adt8840a_set_actual_pos (devnum,2,0);
	adt8840a_set_command_pos(devnum,3,0);
	adt8840a_set_actual_pos (devnum,3,0);
	adt8840a_set_command_pos(devnum,4,0);
	adt8840a_set_actual_pos (devnum,4,0);
}

void CEvc8840Dlg::OnInpMove() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
    //************岹***********//
	if(m_bX && m_bY && !m_bZ && !m_bA)             //XY岹
	{
		adt8840a_inp_move2(devnum, 1, 2, m_pulsex, m_pulsey);
	}
	else if(m_bX && !m_bY && m_bZ && !m_bA)             //XZ岹
	{
		adt8840a_inp_move2(devnum,1, 3, m_pulsex, m_pulsez);
	}
	else if(m_bX && !m_bY && !m_bZ && m_bA)             //XA岹
	{
		adt8840a_inp_move2(devnum, 1, 4, m_pulsex, m_pulsea);
	}
	else if(!m_bX && m_bY && m_bZ && !m_bA)            //YZ岹
	{
		adt8840a_inp_move2(devnum, 2, 3, m_pulsey, m_pulsez);
	}
	else if(!m_bX && m_bY && !m_bZ && m_bA)            //YA岹
	{
		adt8840a_inp_move2(devnum, 2, 4, m_pulsey, m_pulsea);
	}
	else if(!m_bX && !m_bY && m_bZ && m_bA)            //ZA岹
	{
		adt8840a_inp_move2(devnum,3, 4, m_pulsez, m_pulsea);
	}
	
    //*************岹**************//
	else if(m_bX && m_bY && m_bZ && !m_bA) //XYZ岹
	{
		adt8840a_inp_move3(devnum,1, 2, 3, m_pulsex, m_pulsey, m_pulsez);
	}
	else if(m_bX && m_bY && !m_bZ && m_bA) //XYA岹
	{
		adt8840a_inp_move3(devnum,1, 2, 4, m_pulsex, m_pulsey, m_pulsea);
	}
	else if(m_bX && !m_bY && m_bZ && m_bA) //XZA岹
	{
		adt8840a_inp_move3(devnum,1, 3, 4, m_pulsex, m_pulsez, m_pulsea);
	}
	else if(!m_bX && m_bY && m_bZ && m_bA) //YZA岹
	{
		adt8840a_inp_move3(devnum,1, 3, 4, m_pulsex, m_pulsez, m_pulsea);
	}
	
    //************岹**********//
	else if(m_bX && m_bY && m_bZ && m_bA)            //XYZW岹
	{
		adt8840a_inp_move4(devnum,m_pulsex, m_pulsey,m_pulsez, m_pulsea);
	}
}

void CEvc8840Dlg::OnChangeStartx() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	adt8840a_set_startv(devnum, 1, m_startx);
}

void CEvc8840Dlg::OnChangeStarty() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	adt8840a_set_startv(devnum, 2, m_starty);
}

void CEvc8840Dlg::OnChangeStartz() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	adt8840a_set_startv(devnum, 3, m_startz);
}

void CEvc8840Dlg::OnChangeStarta() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	adt8840a_set_startv(devnum, 4, m_starta);
}

void CEvc8840Dlg::OnChangespeedx() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	adt8840a_set_speed (devnum, 1, m_wspeedx);	
}

void CEvc8840Dlg::OnChangespeedy() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	adt8840a_set_speed (devnum, 2, m_wspeedy);
}

void CEvc8840Dlg::OnChangespeedz() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	adt8840a_set_speed (devnum, 3, m_wspeedz);
}

void CEvc8840Dlg::OnChangespeeda() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	adt8840a_set_speed (devnum, 4, m_wspeeda);
}

void CEvc8840Dlg::OnChangeAddsx() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	adt8840a_set_acc (devnum, 1, m_addx);
}

void CEvc8840Dlg::OnChangeAddsy() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	adt8840a_set_acc (devnum, 2, m_addy);
}

void CEvc8840Dlg::OnChangeAddsz() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	adt8840a_set_acc (devnum, 3, m_addz);
}

void CEvc8840Dlg::OnChangeAddsa() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	adt8840a_set_acc (devnum, 4, m_adda);
}

void CEvc8840Dlg::OnFifo() 
{
	// TODO: Add your control notification handler code here
	//************岹***********//
	if(m_bX && !m_bY && !m_bZ && !m_bA) 
	{
		adt8840a_fifo_inp_move1(devnum,1,m_pulsex,2000);
	}		
	else if(!m_bX && m_bY && !m_bZ && !m_bA)
	{
		adt8840a_fifo_inp_move1(devnum,2,m_pulsey,2000);
	}
	else if(!m_bX && !m_bY && m_bZ && !m_bA)
	{
		adt8840a_fifo_inp_move1(devnum,3,m_pulsez,2000);
	}
	else if(!m_bX && !m_bY && !m_bZ && m_bA)
	{
		adt8840a_fifo_inp_move1(devnum,4,m_pulsea,2000);
	}
    //************岹***********//
	if(m_bX && m_bY && !m_bZ && !m_bA)             //XY岹
	{
		adt8840a_fifo_inp_move2(devnum, 1, 2, m_pulsex, m_pulsey,2000);
	}
	else if(m_bX && !m_bY && m_bZ && !m_bA)             //XZ岹
	{
		adt8840a_fifo_inp_move2(devnum,1, 3, m_pulsex, m_pulsez,2000);
	}
	else if(m_bX && !m_bY && !m_bZ && m_bA)             //XA岹
	{
		adt8840a_fifo_inp_move2(devnum, 1, 4, m_pulsex, m_pulsea,2000);
	}
	else if(!m_bX && m_bY && m_bZ && !m_bA)            //YZ岹
	{
		adt8840a_fifo_inp_move2(devnum, 2, 3, m_pulsey, m_pulsez,2000);
	}
	else if(!m_bX && m_bY && !m_bZ && m_bA)            //YA岹
	{
		adt8840a_fifo_inp_move2(devnum, 2, 4, m_pulsey, m_pulsea,2000);
	}
	else if(!m_bX && !m_bY && m_bZ && m_bA)            //ZA岹
	{
		adt8840a_fifo_inp_move2(devnum,3, 4, m_pulsez, m_pulsea,2000);
	}
	
    //*************岹**************//
	else if(m_bX && m_bY && m_bZ && !m_bA) //XYZ岹
	{
		adt8840a_fifo_inp_move3(devnum,1, 2, 3, m_pulsex, m_pulsey, m_pulsez,2000);
	}
	else if(m_bX && m_bY && !m_bZ && m_bA) //XYA岹
	{
		adt8840a_fifo_inp_move3(devnum,1, 2, 4, m_pulsex, m_pulsey, m_pulsea,2000);
	}
	else if(m_bX && !m_bY && m_bZ && m_bA) //XZA岹
	{
		adt8840a_fifo_inp_move3(devnum,1, 3, 4, m_pulsex, m_pulsez, m_pulsea,2000);
	}
	else if(!m_bX && m_bY && m_bZ && m_bA) //YZA岹
	{
		adt8840a_fifo_inp_move3(devnum,1, 3, 4, m_pulsex, m_pulsez, m_pulsea,2000);
	}
	
    //************岹**********//
	else if(m_bX && m_bY && m_bZ && m_bA)            //XYZW岹
	{
		adt8840a_fifo_inp_move4(devnum,m_pulsex, m_pulsey,m_pulsez, m_pulsea,2000);
	}
}

void CEvc8840Dlg::OnPause() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;

	adt8840a_pause(devnum);
	btn=(CButton*)GetDlgItem(IDC_Resume);
	btn->SetCheck(0);
}

void CEvc8840Dlg::OnContinue() 
{
	// TODO: Add your control notification handler code here
	if(m_bX) 
	{
		adt8840a_continue_move(devnum,1,1);
	}		
	if(m_bY)
	{
		adt8840a_continue_move(devnum,2,1);
	}
	if(m_bZ)
	{
		adt8840a_continue_move(devnum,3,1);
	}
	if(m_bA)
	{
		adt8840a_continue_move(devnum,4,1);
	}
}

void CEvc8840Dlg::OnIoTest() 
{
	// TODO: Add your control notification handler code here
	this->KillTimer(1);
	IO_TEST dlg;
	dlg.DoModal();
	SetTimer(MAINTIMER,50,NULL); 	
}

void CEvc8840Dlg::OnResume() 
{
	// TODO: Add your control notification handler code here
	adt8840a_Resume(devnum);
}

void CEvc8840Dlg::OnBufMode() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	adt8840a_set_buff_mode(devnum,m_buffmode);
}

void CEvc8840Dlg::OnSpeedmode() 
{
	// TODO: Add your control notification handler code here
	CEdit *btn;
	UpdateData(TRUE);
	adt8840a_set_speed_mode(devnum,m_speedmode);
	if(m_speedmode)
	{
		btn=(CEdit*)GetDlgItem(IDC_STARTX);
		btn->EnableWindow(FALSE);
		btn=(CEdit*)GetDlgItem(IDC_WSPEEDX);
		btn->EnableWindow(FALSE);
		btn=(CEdit*)GetDlgItem(IDC_ADDSX);
		btn->EnableWindow(FALSE);
		btn=(CEdit*)GetDlgItem(IDC_STARTY);
		btn->EnableWindow(FALSE);
		btn=(CEdit*)GetDlgItem(IDC_WSPEEDY);
		btn->EnableWindow(FALSE);
		btn=(CEdit*)GetDlgItem(IDC_ADDSY);
		btn->EnableWindow(FALSE);
		btn=(CEdit*)GetDlgItem(IDC_STARTZ);
		btn->EnableWindow(FALSE);
		btn=(CEdit*)GetDlgItem(IDC_WSPEEDZ);
		btn->EnableWindow(FALSE);
		btn=(CEdit*)GetDlgItem(IDC_ADDSZ);
		btn->EnableWindow(FALSE);
		btn=(CEdit*)GetDlgItem(IDC_STARTA);
		btn->EnableWindow(FALSE);
		btn=(CEdit*)GetDlgItem(IDC_WSPEEDA);
		btn->EnableWindow(FALSE);
		btn=(CEdit*)GetDlgItem(IDC_ADDSA);
		btn->EnableWindow(FALSE);
	}else
	{
		adt8840a_set_startv(devnum, 1, m_startx);
		adt8840a_set_startv(devnum, 2, m_starty);
		adt8840a_set_startv(devnum, 3, m_startz);
		adt8840a_set_startv(devnum, 4, m_starta);
		adt8840a_set_speed (devnum, 1, m_wspeedx);
		adt8840a_set_speed (devnum, 2, m_wspeedy);
		adt8840a_set_speed (devnum, 3, m_wspeedz);
		adt8840a_set_speed (devnum, 4, m_wspeeda);
		adt8840a_set_acc (devnum, 1, m_addx);
		adt8840a_set_acc (devnum, 2, m_addy);
		adt8840a_set_acc (devnum, 3, m_addz);
		adt8840a_set_acc (devnum, 4, m_adda);
		btn=(CEdit*)GetDlgItem(IDC_STARTX);
		btn->EnableWindow(TRUE);
		btn=(CEdit*)GetDlgItem(IDC_WSPEEDX);
		btn->EnableWindow(TRUE);
		btn=(CEdit*)GetDlgItem(IDC_ADDSX);
		btn->EnableWindow(TRUE);
		btn=(CEdit*)GetDlgItem(IDC_STARTY);
		btn->EnableWindow(TRUE);
		btn=(CEdit*)GetDlgItem(IDC_WSPEEDY);
		btn->EnableWindow(TRUE);
		btn=(CEdit*)GetDlgItem(IDC_ADDSY);
		btn->EnableWindow(TRUE);
		btn=(CEdit*)GetDlgItem(IDC_STARTZ);
		btn->EnableWindow(TRUE);
		btn=(CEdit*)GetDlgItem(IDC_WSPEEDZ);
		btn->EnableWindow(TRUE);
		btn=(CEdit*)GetDlgItem(IDC_ADDSZ);
		btn->EnableWindow(TRUE);
		btn=(CEdit*)GetDlgItem(IDC_STARTA);
		btn->EnableWindow(TRUE);
		btn=(CEdit*)GetDlgItem(IDC_WSPEEDA);
		btn->EnableWindow(TRUE);
		btn=(CEdit*)GetDlgItem(IDC_ADDSA);
		btn->EnableWindow(TRUE);
	}
}

void CEvc8840Dlg::OnSYSSET() 
{
	// TODO: Add your control notification handler code here
	
	this->KillTimer(MAINTIMER);
	SYSPARASET dlg;
	dlg.DoModal();	
	OnSpeedmode();
	SetTimer(MAINTIMER,50,NULL);
}
